
CREATE TABLE suppliers (
id INT AUTO_INCREMENT PRIMARY KEY,
name VARCHAR(150) NOT NULL,
email VARCHAR(150),
phone VARCHAR(50),
created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB;

CREATE TABLE customers (
id INT AUTO_INCREMENT PRIMARY KEY,
name VARCHAR(150) NOT NULL,
email VARCHAR(150),
phone VARCHAR(50),
address VARCHAR(255),
created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB;


CREATE TABLE products (
id INT AUTO_INCREMENT PRIMARY KEY,
name VARCHAR(150) NOT NULL,
category ENUM('ovoce','zelenina') NOT NULL,
price DECIMAL(10,2) NOT NULL DEFAULT 0.00,
stock INT NOT NULL DEFAULT 0,
supplier_id INT NULL,
created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
FOREIGN KEY (supplier_id) REFERENCES suppliers(id) ON DELETE SET NULL
) ENGINE=InnoDB;


-- Ukázková data
INSERT INTO suppliers (name, email, phone) VALUES
('Zahradnictví Novák','novak@example.com','+420601123456'),
('Bio Farma','info@biofarma.cz','+420602987654');


INSERT INTO products (name, category, price, stock, supplier_id) VALUES
('Jablko Golden','ovoce',25.50,100,1),
('Mrkev','zelenina',12.00,50,2);